<?php
require_once("../config/session.php");
require_once("../config/connection.php");

// Check authentication
confirm_logged_in();

// Verify POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die('Method not allowed');
}

// Verify CSRF token
if (!csrf_verify($_POST['csrf_token'] ?? null)) {
    http_response_code(403);
    die('Invalid CSRF token');
}

$data = get_str('data');

if (!empty($data)) {
    $reorderData = json_decode($data, true);
    
    // Validate JSON decode
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        die('Invalid JSON data');
    }
    
    // Validate data structure
    if (!is_array($reorderData)) {
        http_response_code(400);
        die('Invalid data format');
    }

    // Loop through the reorderData array and update the order in the database
    foreach ($reorderData as $id => $newOrder) {
        // Validate ID and order are integers
        $id = filter_var($id, FILTER_VALIDATE_INT);
        $newOrder = filter_var($newOrder, FILTER_VALIDATE_INT);
        
        if ($id === false || $newOrder === false) {
            continue; // Skip invalid entries
        }
        
        // Use prepared statement to prevent SQL injection
        $stmt = $mysqli->prepare("UPDATE app_menu SET order_id = ? WHERE id = ?");
        $stmt->bind_param("ii", $newOrder, $id);
        $stmt->execute();
        $stmt->close();
    }

    echo json_encode(['success' => true, 'message' => 'Order updated successfully']);
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'No data received']);
}
?>
